/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.jdt.internal;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.sonarlint.eclipse.core.configurator.ProjectConfigurationRequest;
import org.sonarlint.eclipse.core.configurator.ProjectConfigurator;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.jdt.internal.JavaProjectConfiguration;
import org.sonarlint.eclipse.jdt.internal.SonarJdtPlugin;

public class JavaProjectConfigurator
extends ProjectConfigurator {
    public boolean canConfigure(IProject project) {
        return SonarJdtPlugin.hasJavaNature(project);
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) {
        IProject project = request.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.configureJavaProject(javaProject, request.getSonarProjectProperties());
    }

    public void configureJavaProject(IJavaProject javaProject, Map<String, String> sonarProjectProperties) {
        String javaSource = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String javaTarget = javaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
        sonarProjectProperties.put("sonar.java.source", javaSource);
        sonarProjectProperties.put("sonar.java.target", javaTarget);
        try {
            JavaProjectConfiguration configuration = new JavaProjectConfiguration();
            configuration.dependentProjects().add(javaProject);
            this.addClassPathToSonarProject(javaProject, configuration, true);
            JavaProjectConfigurator.configurationToProperties(sonarProjectProperties, configuration);
        }
        catch (JavaModelException e) {
            SonarLintCorePlugin.getDefault().error(e.getMessage(), (Throwable)e);
        }
    }

    private void addClassPathToSonarProject(IJavaProject javaProject, JavaProjectConfiguration context, boolean topProject) throws JavaModelException {
        IClasspathEntry[] classPath;
        IClasspathEntry[] iClasspathEntryArray = classPath = javaProject.getResolvedClasspath(true);
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            switch (entry.getEntryKind()) {
                case 3: {
                    if (JavaProjectConfigurator.isSourceExcluded(entry)) break;
                    this.processSourceEntry(entry, javaProject, context, topProject);
                    break;
                }
                case 1: {
                    String libPath;
                    if (!topProject && !entry.isExported() || (libPath = JavaProjectConfigurator.resolveLibrary(javaProject, entry)) == null) break;
                    context.libraries().add(libPath);
                    break;
                }
                case 2: {
                    IJavaModel javaModel = javaProject.getJavaModel();
                    IJavaProject referredProject = javaModel.getJavaProject(entry.getPath().segment(0));
                    if (context.dependentProjects().contains(referredProject)) break;
                    context.dependentProjects().add(referredProject);
                    this.addClassPathToSonarProject(referredProject, context, false);
                    break;
                }
                default: {
                    SonarLintCorePlugin.getDefault().info("Unhandled ClassPathEntry : " + entry);
                }
            }
            ++n2;
        }
        JavaProjectConfigurator.processOutputDir(javaProject.getOutputLocation(), context, topProject);
    }

    private static void processOutputDir(IPath outputDir, JavaProjectConfiguration context, boolean topProject) throws JavaModelException {
        String outDir = JavaProjectConfigurator.getAbsolutePath((IPath)outputDir);
        if (outDir != null) {
            if (topProject) {
                context.binaries().add(outDir);
            } else {
                context.libraries().add(outDir);
            }
        } else {
            SonarLintCorePlugin.getDefault().info("Binary directory was not added because it was not found. Maybe should you enable auto build of your project.");
        }
    }

    private void processSourceEntry(IClasspathEntry entry, IJavaProject javaProject, JavaProjectConfiguration context, boolean topProject) throws JavaModelException {
        String srcDir = this.getRelativePath(javaProject.getPath(), entry.getPath());
        if (srcDir == null) {
            SonarLintCorePlugin.getDefault().info("Skipping non existing source entry: " + entry.getPath().toOSString());
            return;
        }
        if (entry.getOutputLocation() != null) {
            JavaProjectConfigurator.processOutputDir(entry.getOutputLocation(), context, topProject);
        }
    }

    private static String resolveLibrary(IJavaProject javaProject, IClasspathEntry entry) {
        IResource member = JavaProjectConfigurator.findPath(javaProject.getProject(), entry.getPath());
        String libPath = member != null ? member.getLocation().toOSString() : entry.getPath().makeAbsolute().toOSString();
        if (!new File(libPath).exists()) {
            return null;
        }
        return libPath.endsWith(File.separator) ? libPath.substring(0, libPath.length() - 1) : libPath;
    }

    private static IResource findPath(IProject project, IPath path) {
        IResource member = project.findMember(path);
        if (member == null) {
            IWorkspaceRoot workSpaceRoot = project.getWorkspace().getRoot();
            member = workSpaceRoot.findMember(path);
        }
        return member;
    }

    private static boolean isSourceExcluded(IClasspathEntry entry) {
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        if (exclusionPatterns != null) {
            IPath[] iPathArray = exclusionPatterns;
            int n = exclusionPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                IPath exclusionPattern = iPathArray[n2];
                if ("**".equals(exclusionPattern.toString())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static void configurationToProperties(Map<String, String> sonarProjectProperties, JavaProjectConfiguration context) {
        JavaProjectConfigurator.setPropertyList(sonarProjectProperties, (String)"sonar.libraries", context.libraries());
        JavaProjectConfigurator.setPropertyList(sonarProjectProperties, (String)"sonar.java.libraries", context.libraries());
        JavaProjectConfigurator.setPropertyList(sonarProjectProperties, (String)"sonar.java.test.libraries", context.libraries());
        JavaProjectConfigurator.setPropertyList(sonarProjectProperties, (String)"sonar.binaries", context.binaries());
        JavaProjectConfigurator.setPropertyList(sonarProjectProperties, (String)"sonar.java.binaries", context.binaries());
        JavaProjectConfigurator.setPropertyList(sonarProjectProperties, (String)"sonar.java.test.binaries", context.binaries());
    }
}

